globals
[
    ratioBrewer
    ratioWholesaler
    ratioRetailer
    userNumbersToNames
    retailers
    brewers
    wholesalers
    day

    brewerPurchaseCost
    brewerSalePrice
    brewerStorageCost

]

breeds
[
    player
]

player-own
[
    myUserId ; the hubnet id that corresponds to this turtle
    ; ordersPlaced ; doesn't seem to be used
    clients ; folks downstream of me
    supplier ; who goves me my beer
    inventory  ; what i have on hand
    ; demand  ; victor, what was this for ?? --rbs
    waitingList ; orders i need to fill
    playerType  ; "retailer", "brewer", "wholesaler"
    lastShipment ; the last shipment i received
    lastWeekDemand ; the demand i saw over the last week
    nextOrder    ; how much to place on my next order
    bankAccount  ;how much money i have
    revenueNotGotten
    breweryList ; used only by brewers
]

to startup
  hubnet-set-client-interface "COMPUTER" [ "clients/Beer Game Alternate 2 client.nlogo" ]
  hubnet-reset
  setup
end


to setup
    set ratioBrewer 1
    set ratioWholesaler 2
    set ratioRetailer 6
    set userNumbersToNames []
    set day 0
    
    set brewerPurchaseCost .25
    set brewerSalePrice .6
    set brewerStorageCost .10
end

to Go
    ;ask player [ sendInfoToClient ]
    advanceClock
    processOrders    
    ask player [ sendInfoToClient ]
    ;ask player [ set lastWeekDemand 0 ]
    wait 2
end

to reset
    set day 0
    ask player
    [
        resetPlayerValues
    ]
end


to advanceClock
    set day day + 1
end

to processOrders
    if (day > 6 ) and (currentDay day  = "Friday") ; the day the supppliers receive new orders
    [
        ask player with [(playerType = "wholesaler") or (playerType = "brewer")]
        [
            set lastWeekDemand 0
        ]
    ]
    if (day > -1 ) and (currentDay day  = "Tuesday") ; the day the supppliers receive new orders
    [
        ask player ;with [(playerType = "wholesaler") or (playerType = "brewer")]
        [
            set lastShipment 0
        ]
    ]
;    if currentDay day = "Saturday" ; the day the Brewers receive new orders
;    [
;        ask player with [playerType = "brewer"]
;        [
;            set lastWeekDemand 0
;        ]
;    ]
    ask player
    [
        pump
    ]
end



to-report RepresentDay [d] ;;convert from a day number to a pretty string
    report (currentDay d) + " of Week " + (currentWeek d)
end

to-report currentDay [d]
    if d mod 7 = 0
    [
        report "Sunday"
    ]
    if d mod 7 = 1
    [
        report "Monday"
    ]
    if d mod 7 = 2
    [
        report "Tuesday"
    ]
    if d mod 7 = 3
    [
        report "Wednesday"
    ]
    if d mod 7 = 4
    [
        report "Thursday"
    ]
    ifelse d mod 7 = 5
    [
        report "Friday"
    ]
    [
        report "Saturday"
    ]
end

to-report currentWeek [d]
    report floor (1 + (d / 7))
end ;reports current week

;;;;;;;;;;;;;;;;;;;
; Player procedures
;;;;;;;;;;;;;;;;;;;
to add-new-client [newclient]
    set clients fput newclient clients
end ;add new client to supplier's list


;;;;;;;;;;;;;
;victor's code of death
;;;;;;;;;;;;;

to chargeForStorage
    set bankAccount (bankAccount - (inventory * roleCoefficient playerType) * brewerStorageCost) ;charge for leftover inventory    
end

to placeOrder [myOrder] ; myOrder = number of units to order
    ;show myUserId + "lowering account for " + inventory + " times " + roleCoefficient playerType * brewerStorageCost
    ifelse playerType = "brewer"
    [
        without-interruption
        [
            set breweryList lput myOrder breweryList 
        ]
    ]
    [ ; everybody Else
        let newOrder list myUserId myOrder
        ;show "Created a new order: " + newOrder
        ask supplier ;player with [myUserId = supplier-of myself]
        [
            without-interruption
            [
                let tempList lput newOrder first reverse waitingList
                ;set tempList lput (list (myUserId-of myself) myOrder) (first (reverse waitingList))
                set waitingList replace-item ( (length waitingList) - 1)  waitingList tempList
                ;set waitingList reverse (fput tempList (butfirst reverse waitingList))
                set lastWeekDemand lastWeekDemand + myOrder ;update what will be the suppliers demand
            ]
            ;sendInfoToClient
        ]
    ]
end 


to pump
    ;    Place        Receive
    ;R    Fri        Tue
    ;W    Fri        Tue
    ;B    Fri        Tue        
    
    if currentDay day = "Tuesday"
    [
        chargeForStorage
    ]
     
    if playerType = "retailer"
    [
        ifelse (inventory > 0) and (consumerDemand > 0)
        [
            ifelse (consumerDemand < inventory)
            [
                set bankAccount (bankAccount + (4 * brewerSalePrice * consumerDemand))
                set inventory (inventory - consumerDemand)
            ]
            [
                if (consumerDemand > inventory)
                [
                    set bankAccount (bankAccount + (4 * brewerSalePrice * inventory))
                    set revenueNotGotten revenueNotGotten + (4 * brewerSalePrice * abs (consumerDemand - inventory))
                    set inventory 0
                ]
            ]    
        ]
        [ ;else
            if inventory = 0
            [
                set revenueNotGotten revenueNotGotten + (4 * brewerSalePrice * (consumerDemand))
            ]
        ]
;        ifelse ((inventory - consumerDemand) >= 0)
;        [
;            set inventory (inventory - consumerDemand)
;            
;        ]
;        [
;            
;            set inventory 0
;        ]
                   
                                
        if currentDay day = "Friday"
        [
            placeOrder nextOrder
        ]
    ]
    if playerType = "wholesaler"
    [
        if currentDay day = "Tuesday"
        [
            supplyDownstream
        ]
        if currentDay day = "Friday"
        [
            placeOrder nextOrder
        ]
    ]
    if playerType = "brewer"
    [
        if currentDay day = "Tuesday"
        [
            without-interruption
            [
                set inventory inventory + first breweryList
                set lastShipment first breweryList
                set bankAccount (bankAccount - first breweryList * brewerPurchaseCost)
                set breweryList butfirst breweryList
            ]
        ]
        if currentDay day = "Tuesday"
        [
            supplyDownstream
        ]
        if currentDay day = "Friday"
        [
            placeOrder nextOrder
        ]
    ]
end  
    
to-report roleCoefficient [role]
    if role = "brewer"
    [
        report 1
    ]
    if role = "wholesaler"
    [
        report 2
    ]
    if role = "retailer"
    [
        report 4
    ]
end


to supplyDownstream
    let thisWeek 0

    ;; pop the first guy off
    without-interruption
    [
        set thisWeek first waitingList
        set waitingList lput [] butfirst waitingList
    ]
    let keepLooping true
    ;; go through the shit from this week
    while [keepLooping = true]
    [
        if inventory = 0
        [
            set keepLooping  false
        ]
        ifelse everybodyFilled? thisWeek
        [
            set keepLooping  false
        ]
        [
            set thisWeek fillFirstOrder thisWeek
        ]
    ]
    
    if inventory = 0 ; push stuff into being due next week
    [
        set waitingList replace-item 0 waitingList mergeWeeks (reverse thisWeek) first waitingList 
    ]
    
    
    
end

to-report mergeWeeks [leftWeek rightWeek] ;;returns the result of merging the two weeks passed as params. I guess netlogo doesn't have some sort of list merging operator...
    ifelse length leftWeek = 0
    [
        report rightWeek
    ]
    [
        report mergeWeeks butfirst leftWeek fput first leftWeek rightWeek
    ]

end

to-report fillFirstOrder [openWeek] ;;allocates one unit from inventory to the first open order, removes empty orders from this weeks queue

    let newOrder []
    
    if inventory < 1
    [
        report openWeek
    ]
    
    if length openWeek = 0
    [
        report []
    ]
    
    if not is-number? (first butfirst first openWeek)
    [
        show "openWeek: " + openWeek
        show 3 / 0
    ]
    
    ifelse ((first butfirst first openWeek) < 1) ;; in other words, this order has been filled
    [
        report fillFirstOrder butfirst openWeek
    ]
    [
        let toWhom first first openWeek
        ;;increase the recipient's inventory by one
        without-interruption
        [
            ask player with [myUserId = toWhom]
            [
                set inventory inventory + 1
                set bankAccount (bankAccount - roleCoefficient playerType * brewerPurchaseCost) ;charge the client for the one beer
                set lastShipment lastShipment + 1
            ]
            set inventory inventory - 1
            set bankAccount (bankAccount + roleCoefficient playerType * brewerSalePrice) ;add money to my account
            let newAmount ( ( first butfirst first openWeek) - 1 )
            set newOrder list toWhom  newAmount
        ]
        report lput  newOrder   butfirst openWeek
    ]
    
    
end

to-report sumOfOrdersForWeek [aWeek] ;; report the sum of the orders that are due this week

    ifelse (length aWeek) = 0
    [
        report 0
    ]
    [
        report first butfirst first aWeek + sumOfOrdersForWeek butfirst aWeek
    ]

end

to-report everybodyFilled? [orders] ;; report true if all the orders are down to zero
    ifelse 0 = length orders
    [
        report true
    ]
    [
        ifelse 0 = first butfirst first orders
        [
            report everybodyFilled? butfirst orders
        ]
        [
            report false
        ]
    ]
    
end


to initializePlayer [newUserId newPlayerType newSupplier newInventory]
        show newUserId + " has supplier " +  newSupplier + " inv = " + newInventory
        set myUserId newUserId
        set clients []
        set supplier newSupplier
        set inventory newInventory
        ;set demand 0
        set playerType newPlayerType
        resetPlayerValues
        
        if supplier != nobody
        [
            ask supplier
            [
                add-new-client myself
            ]
        ]

end

to resetPlayerValues
    show "resetPlayerValues for " + myUserId
        ifelse (playerType = "retailer")
        [
            set lastWeekDemand consumerDemand * 7 ; ; not used  
            set waitingList [ [] ]
            set inventory startingRetailerInventory
        ];else
        [
            ifelse (playerType = "wholesaler")
            [
                set waitingList [ [] [] [] [] ]
                set lastWeekDemand floor (consumerDemand * 7 * (ratioRetailer / ratioWholesaler))
                set inventory startingWholesalerInventory   
            ]
            [ ;; brewer
                set waitingList [ [] [] [] [] ]
                set lastWeekDemand floor (consumerDemand * 7 * (ratioRetailer / ratioBrewer ) )
                set breweryList (list lastWeekDemand lastWeekDemand )
                set inventory startingBrewerInventory
            ]
        ]
        set lastShipment lastWeekDemand
        set nextOrder lastShipment
        set bankAccount 100
        set revenueNotGotten 0.00        
end

to processMessage [incomingMessage]
    if incomingMessage = "^"
    [
        set nextOrder nextOrder + 7
    ]
    if incomingMessage = "v" and nextOrder > 0
    [
        set nextOrder nextOrder - 7
    ]
    hubnet-send myUserId "Next Order To Place" nextOrder
    ;    sendInfoToClient
end

to sendOneTimeInfo
    hubnet-send myUserId "You are a" playerType
    ifelse playerType = "brewer"
    [
        hubnet-send myUserId "Your Supplier Is" "not applicable"
    ]
    [
        hubnet-send myUserId "Your Supplier Is" myUserId-of supplier  
    ]
    hubnet-send myUserId "Sale Price per Beer" "$" + roleCoefficient playerType * brewerSalePrice + "0"
    ifelse playerType = "brewer" ;to prevent purchase price being $0.250
    [
        hubnet-send myUserId "Purchase Cost per Beer" "$" + roleCoefficient playerType * brewerPurchaseCost
    ]
    [
        hubnet-send myUserId "Purchase Cost per Beer" "$" + roleCoefficient playerType * brewerPurchaseCost + "0"
    ]
    hubnet-send myUserId "Storage Cost per Beer" "$" + roleCoefficient playerType * brewerStorageCost + "0"
end    



to sendInfoToClient 
  hubnet-send myUserId "Inventory On Hand" inventory
  hubnet-send myUserId "Last Incoming Shipment" lastShipment
  ;hubnet-send myUserId "Waiting List" waitingList
  hubnet-send myUserId "Today Is" RepresentDay day
  hubnet-send myUserId "Next Order To Place" nextOrder
  ifelse playerType = "retailer"
  [
      hubnet-send myUserId "Current Downstream Demand" "" + (consumerDemand * 7) + " per week"
  ]
  [
      hubnet-send myUserId "Current Downstream Demand" lastWeekDemand
  ]
  ifelse playerType = "retailer"
  [
      hubnet-send myUserId "Potential Revenue Missed" "$" + precision revenueNotGotten 2 + "0"
      
      hubnet-send myUserId "Requested for delivery this week" "not applicable"
  ]
  [
      hubnet-send myUserId "Potential Revenue Missed" "not applicable"
      hubnet-send myUserId "Requested for delivery this week" sumOfOrdersForWeek first waitingList
  ]
  ifelse day < 2 ;if it's before the first Tuesday, don't show the extra 0
  [
      hubnet-send myUserId "Bank Account" "$" + precision bankAccount 2
  ]
  [
      hubnet-send myUserId "Bank Account" "$" + precision bankAccount 2 + "0"
  ]
end

to BuildAllInitialWaitingLists ; observer
    ask player with [(playerType = "brewer") or (playerType = "wholesaler")]
    [
        buildMyInitialWaitingList
    ]
end

to buildMyInitialWaitingList ; for when we start the game, to be called after everyone has joined
    show "building " + myUserId + "'s initial waiting list using: " + waitingList
    let doTimes length waitingList
    set waitingList []
    repeat doTimes
    [
        set waitingList fput makeOneWeekInitialWaitingList waitingList
    ]
    
end

to-report makeOneWeekInitialWaitingList ; player procedure
    let myOutput []
    let incredibleShrinkingClients clients
    
    
    repeat length clients
    [
;        show "making week with remainder list :  " + incredibleShrinkingClients
        set myOutput fput  (list myUserId-of first incredibleShrinkingClients nextOrder-of first incredibleShrinkingClients  )  myOutput
        set incredibleShrinkingClients butfirst incredibleShrinkingClients
    ]
    report    myOutput
end





;;;;;;;;;;;;;;;;;;;;;;;;
;Client-Server Stuff   ;
;;;;;;;;;;;;;;;;;;;;;;;;

to listen-clients
  while [ hubnet-message-waiting? ]
  [
    hubnet-fetch-message
    ifelse hubnet-enter-message?
    [ onUserConnect hubnet-message-source ]
    [
      ifelse hubnet-exit-message?
      [ noOp ]
      [ 
          ask player with [myUserId = hubnet-message-source]
          [
              processMessage hubnet-message-tag
          ]
      ]
    ]
  ]
end
    
            
to onUserConnect [newUserId]
    set userNumbersToNames lput newUserId userNumbersToNames 
    create-custom-player 1
    [
        initializePlayer newUserId 
                         (getRole getUserNumber newUserId)
                         (getBestSupplier getRole getUserNumber newUserId)
                         defaultStartInventory getRole getUserNumber newUserId                         
        sendInfoToClient 
        sendOneTimeInfo
    ]
end



to noOp
end


to-report defaultStartInventory [role]
    ifelse role = "retailer"
    [
        report startingRetailerInventory
    ]
    [
        ifelse role = "wholesaler"
        [
            report startingWholesalerInventory
        ]
        [
            report startingBrewerInventory
        ]
    ]
end;reports starting inventory as read from slider

to-report getBestSupplier [role] ;;used to assign new players their upstream
  
    ifelse role = "retailer"
    [
        report min-one-of (player with [playerType = "wholesaler"]) [length clients]  
    ]
    [
        ifelse role = "wholesaler"
        [
            report min-one-of (player with [playerType = "brewer"]) [length clients] 
        ]
        [
            report nobody
        ]
    ]       
end ;;getBestSupplier

to-report getUserNumber [userId]
    report position userId userNumbersToNames
end

to-report getUserName [userNumber]
    report item userNumber userNumbersToNames
end

to-report getRole [n] ;; get the role of the nTh person to join
                      ;; outputs "brewer", "wholesaler", or "retailer" depending upon what the new user should be  
    let postMod n mod (ratioBrewer + ratioWholesaler + ratioRetailer) 
    ifelse postMod < ratioBrewer
    [
        report "brewer"
    ]
    [
        ifelse postMod < ratioWholesaler + ratioBrewer
        [
            report "wholesaler"
        ]
        [
            report "retailer"
        ]
    ]
end ;;getRole


; *** NetLogo Model Copyright Notice ***
;
; This activity and associated models and materials was created as part of the projects:
; PARTICIPATORY SIMULATIONS: NETWORK-BASED DESIGN FOR SYSTEMS LEARNING IN CLASSROOMS and 
; INTEGRATED SIMULATION AND MODELING ENVIRONMENT.
; These projects gratefully acknowledge the support of the 
; National Science Foundation (REPP & ROLE programs) -- grant numbers 
; REC #9814682 and REC-0126227.
;
; Copyright 2003 by Uri Wilensky & Walter Stroup. Updated 2003. All rights reserved.
;
; Permission to use, modify or redistribute this model is hereby granted,
; provided that both of the following requirements are followed:
; a) this copyright notice is included.
; b) this model will not be redistributed for profit without permission
;    from the copyright holders.
; Contact the copyright holders for appropriate licenses for redistribution 
; for profit.
;
; To refer to this model in academic publications, please use:
; Wilensky, U. & Stroup, W. (2003).  NetLogo HubNet Beer Game Alternate 2 model.
; http://ccl.northwestern.edu/netlogo/models/HubNetBeerGameAlternate2
; Center for Connected Learning and Computer-Based Modeling,
; Northwestern University, Evanston, IL.
;
; In other publications, please use:
; Copyright 2003 by Uri Wilensky and Walter Stroup.  All rights reserved.  See
; http://ccl.northwestern.edu/netlogo/models/HubNetBeerGameAlternate2
; for terms of use.
;
; *** End of NetLogo Model Copyright Notice ***
@#$#@#$#@
GRAPHICS-WINDOW
502
473
687
679
17
17
5.0
1
10
1
1
1
0

CC-WINDOW
5
693
696
788
Command Center

BUTTON
314
41
426
74
Go
Go
T
1
T
OBSERVER
T
NIL

SLIDER
51
83
252
116
startingBrewerInventory
startingBrewerInventory
0
200
126
1
1
NIL

SLIDER
50
151
251
184
startingRetailerInventory
startingRetailerInventory
0
50
21
1
1
NIL

SLIDER
50
117
251
150
startingWholesalerInventory
startingWholesalerInventory
0
100
63
1
1
NIL

SLIDER
64
195
236
228
ConsumerDemand
ConsumerDemand
0
50
1
1
1
NIL

BUTTON
17
41
88
74
Listen
listen-clients
T
1
T
OBSERVER
T
NIL

MONITOR
76
262
214
311
Day
RepresentDay day
3
1

BUTTON
357
97
427
130
Reset
reset
NIL
1
T
OBSERVER
T
NIL

BUTTON
108
41
297
74
Ready To Go
buildAllInitialWaitingLists
NIL
1
T
OBSERVER
T
NIL

@#$#@#$#@
SPECIAL NOTE
------------
"Beer Game Alternate 1" and "Beer Game Alternate 2" are supplied with this release as examples of other possible approaches to designing and implementing a Beer Game activity.  The main Beer Game activity is the one we have developed most fully in terms of: design; reliability and robustness; documentation; and quality of code.  However, we felt that users might also be interested in seeing these other implementations.  Be cautious if intending to use the alternates with an actual group.


WHAT IS IT?
-----------
This is a HubNet Participatory simulation of the Beer Game. The beer game is a model of a product distribution system. 

Players play as either retailers (who see demand from consumers and order from wholesalers), wholesalers (who see demand from retailers and order from brewers), or brewers (who see demand from wholesalers and produce the beer to give to wholesalers). Players try to maximize their profit, which is derived from selling the most beer possible. Buying beer and keeping it in inventory costs money. Crucial is the fact that beer is not delivered immediately upon order placement; rather, retailers and wholesalers wait an average of four weeks to receive their orders. Wholesalers and brewers maintain a waiting list of orders received but not yet filled. Beer to satisfy this waiting list is alloted as soon as possible.


HOW TO USE IT
-------------
For the administrator, press the Listen button and leave it pressed while participants log onto the simulation.  Once everyone is logged on, click the Ready To Go button.  When you are ready to begin play, click Go and leave it depressed until you wish to end play.

For players, the only actions required while playing the game are increasing and decreasing the size of orders placed each week. The interface tells players what their role is, who their supplier is, and the financial costs and revenues per unit of beer. Orders are sent to the supplier using whatever value is in the Next Order to Place monitor on Friday.  Orders are received on Tuesday.  Inventory costs are assessed on Tuesday also.

The Requested for delivery monitor (only used by wholesalers and brewers) tells users how much beer should be delivered in the current week. For example, if two units were ordered four weeks ago to be delivered this week and two units last week went unfilled, the requested for delivery monitor would indicate four. 


THINGS TO NOTICE
----------------
While playing, players should try to make note of how demand changes over time. This can be useful in analyzing the behavior of the system at the end of the game. 



THINGS TO TRY
-------------
The administrator of the game should initially let consumer demand remain stable. Once players are comfortable with the steady state of the system, the administrator should double or triple consumer demand. Players who are unfamiliar with the emergent dynamics of the system will often greatly exaggerate the change in demand when placing their own orders. Usually, this results in bankrupcy. 


EXTENDING THE MODEL
-------------------
Users could modify the model to change the latencies of the game or to adjust the ratio of retailers to wholesalers to brewers.  Also, try to add an additional role in the system, such as a distributor.  See if this changes the dynamics of the system.


NETLOGO FEATURES
----------------
This model uses NetLogo's HubNet to handle interactions with players. A future version of this model will use NetLogo's nascent  peer-to-peer networking to allow players to customize the information they see during game play, as well as write code to play on their behalf. 


RELATED MODELS
--------------
Tragedy of the Commons


CREDITS AND REFERENCES
----------------------
See Senge's "The Fifth Discipline" for more information about the beer game.

This activity and associated models and materials was created as part of the projects:
PARTICIPATORY SIMULATIONS: NETWORK-BASED DESIGN FOR SYSTEMS LEARNING IN CLASSROOMS and INTEGRATED SIMULATION AND MODELING ENVIRONMENT. These projects gratefully acknowledge the support of the National Science Foundation (REPP & ROLE programs) -- grant numbers REC #9814682 and REC-0126227.

Copyright 2003 by Uri Wilensky & Walter Stroup. All rights reserved. 

Permission to use, modify or redistribute this model is hereby granted, provided that both of the following requirements are followed: 
a) this copyright notice is included. 
b) this model will not be redistributed for profit without permission from the copyright holders. 
Contact the copyright holders for appropriate licenses for redistribution for profit. 

To refer to this model in academic publications, please use: Wilensky, U. & Stroup, W. (2003). NetLogo HubNet Beer Game Alternate 2 model. http://ccl.northwestern.edu/netlogo/models/HubNetBeerGameAlternate2. Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL. 

In other publications, please use: Copyright 2003 by Uri Wilensky and Walter Stroup.  All rights reserved.  See http://ccl.northwestern.edu/netlogo/models/HubNetBeerGameAlternate2 for terms of use.
@#$#@#$#@
default
true
0
Polygon -7566196 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7566196 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7566196 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7566196 true true 150 285 285 225 285 75 150 135
Polygon -7566196 true true 150 135 15 75 150 15 285 75
Polygon -7566196 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7566196 true true 96 182 108
Circle -7566196 true true 110 127 80
Circle -7566196 true true 110 75 80
Line -7566196 true 150 100 80 30
Line -7566196 true 150 100 220 30

butterfly
true
0
Polygon -7566196 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7566196 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7566196 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7566196 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7566196 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7566196 true true 47 195 58
Circle -7566196 true true 195 195 58

circle
false
0
Circle -7566196 true true 30 30 240

circle 2
false
0
Circle -7566196 true true 16 16 270
Circle -16777216 true false 46 46 210

cow
false
0
Polygon -7566196 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7566196 true true 73 210 86 251 62 249 48 208
Polygon -7566196 true true 25 114 16 195 9 204 23 213 25 200 39 123

face happy
false
0
Circle -7566196 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7566196 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7566196 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7566196 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7566196 true true 60 15 75 300
Polygon -7566196 true true 90 150 270 90 90 30
Line -7566196 true 75 135 90 135
Line -7566196 true 75 45 90 45

flower
false
0
Polygon -11352576 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7566196 true true 85 132 38
Circle -7566196 true true 130 147 38
Circle -7566196 true true 192 85 38
Circle -7566196 true true 85 40 38
Circle -7566196 true true 177 40 38
Circle -7566196 true true 177 132 38
Circle -7566196 true true 70 85 38
Circle -7566196 true true 130 25 38
Circle -7566196 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -11352576 true false 189 233 219 188 249 173 279 188 234 218
Polygon -11352576 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7566196 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7566196 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7566196 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7566196 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7566196 true 150 0 150 300

pentagon
false
0
Polygon -7566196 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7566196 true true 110 5 80
Polygon -7566196 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7566196 true true 127 79 172 94
Polygon -7566196 true true 195 90 240 150 225 180 165 105
Polygon -7566196 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7566196 true true 135 90 165 300
Polygon -7566196 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7566196 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7566196 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7566196 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7566196 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7566196 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7566196 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7566196 true true 30 30 270 270

square 2
false
0
Rectangle -7566196 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7566196 true true 60 270 150 0 240 270 15 105 285 105
Polygon -7566196 true true 75 120 105 210 195 210 225 120 150 75

target
false
0
Circle -7566196 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7566196 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7566196 true true 120 120 60

tree
false
0
Circle -7566196 true true 118 3 94
Rectangle -6524078 true false 120 195 180 300
Circle -7566196 true true 65 21 108
Circle -7566196 true true 116 41 127
Circle -7566196 true true 45 90 120
Circle -7566196 true true 104 74 152

triangle
false
0
Polygon -7566196 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7566196 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7566196 true true 4 45 195 187
Polygon -7566196 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7566196 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7566196 false true 24 174 42
Circle -7566196 false true 144 174 42
Circle -7566196 false true 234 174 42

turtle
true
0
Polygon -11352576 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -11352576 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -11352576 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -11352576 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -11352576 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7566196 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7566196 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7566196 true 150 285 150 15
Line -7566196 true 15 150 285 150
Circle -7566196 true true 120 120 60
Line -7566196 true 216 40 79 269
Line -7566196 true 40 84 269 221
Line -7566196 true 40 216 269 79
Line -7566196 true 84 40 221 269

x
false
0
Polygon -7566196 true true 270 75 225 30 30 225 75 270
Polygon -7566196 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 2.1beta2
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
